var heights = [];
var groups_state = [];

function expandCollapse(id) {
    var oldSafari = true;
    var safari =jQuery.browser['safari'];
    var version = Number(jQuery.browser['version'].slice(0,3));
    if(safari && version > 500) {
        oldSafari = false;
    }
    var img = $('#img_' + id);
    var group = $('#group_' + id);
    if(typeof(groups_state[id]) == 'undefined') {
        groups_state[id] = false;
    }
    if(groups_state[id] == true) {
        if(oldSafari) {
            group.fadeOut('slow');
        }
        else {
            group.slideUp('slow');
        }
        img.attr('src', 'images/closed.gif');
        groups_state[id] = false;
    }
    else {
        if(oldSafari) {
            group.fadeIn('slow');
        }
        else {
            group.slideDown('slow');
        }
        img.attr('src', 'images/opened.gif');
        groups_state[id] = true;
    }
}

function deleteMessage(id, groupId) {
	if (!window.syncmate.checkconnected())
		return;
    var realId = id.slice(0,id.indexOf('_'));

    var data = drawCover('Are you sure you want to delete SMS?');
    var yes = data['yes'];
    var alertBox = data['alertBox'];
    var cover = data['cover'];

    yes.attr('href', '#' + id);

    yes.bind('click', function() {
        alertBox.remove();
        cover.remove();
        //processMsg(id, groupId);
        $("div[id^='message_" + realId +"']").each(function(i){
                processMsg(this.id.replace('message_',''), -1);
        });
    });
}

function processMsg(id, groupId) {
    var realId = id.slice(0,id.indexOf('_'));
    var mid;
    var counter;
    var count;
    if(groupId == -1) {
        $("div[class='group']").each(function (i) {
            groupId = this.id.replace('group_','');
            counter = $('#mess_count_' + groupId);
            count = parseInt(counter.html());
            if(count > 0) {
                for(var x = 0; x < this.childNodes.length; x++) {
                    if(typeof(this.childNodes[x].id) != 'undefined' &&
                       this.childNodes[x].id.indexOf('message_') != -1) {
                        mid = this.childNodes[x].id.replace('message_', '');
                            if(mid.slice(0,mid.indexOf('_')) == realId) {
                                dropMsg(mid,groupId);
                            }
                    }
                }
            }
        });
    }
    else {
        dropMsg(id,groupId);
    }
}

function dropMsg(id,groupId) {
    var message = $('#message_' + id);
    message.fadeOut('slow',function() {

		window.syncmate.removemessage_(id);

        message.remove();
        var group = $('#group_' + groupId);
        group.css('height', 'auto');
        heights[groupId] = group.height();

        var counter = $('#mess_count_' + groupId);
        var count = parseInt(counter.html());

        if(count > 1) {
            count--;
            counter.html('' + count + '');
        }
        else {
            var header = $('#group_header_' + groupId);
            header.fadeOut('slow', function() {
                header.remove();
            });
        }
    });
}

function deleteMessagesGroup(groupId) {

	if (!window.syncmate.checkconnected())
		return;
    var data = drawCover('Are you sure you want to delete group?');
    var yes = data['yes'];
    var alertBox = data['alertBox'];
    var cover = data['cover'];
    var messagesIds = new Array();

    $('input[name="message[]"]').each(function() {
        if($(this).val().search(groupId) >= 0) {
            messagesIds.push($(this).val().substr(0, $(this).val().indexOf('|')));
        }
    });

    yes.bind('click', function() {
        alertBox.remove();
        cover.remove();

        for(var i in messagesIds) {
            processMsg(messagesIds[i], -1)
        }
    });
}

function deleteSelectedMessages() {

	if (!window.syncmate.checkconnected())
		return;
    var data = drawCover('Are you sure you want to delete SMS?');
    var yes = data['yes'];
    var alertBox = data['alertBox'];
    var cover = data['cover'];

    yes.bind('click', function() {
        alertBox.remove();
        cover.remove();

        var messagesIds = new Array();

        $('input[name="message[]"]').each(
            function() {
                if($(this).is(':checked')) {
                    var messageId = $(this).val().substr(0, $(this).val().indexOf('|'));
                    var groupId = $(this).val().substr($(this).val().indexOf('|') + 1);
                    messagesIds.push(messageId);
                }
            }
        );

        for(var i in messagesIds) {
            processMsg(messagesIds[i], -1)
        }
		window.syncmate.allunchecked_(true);

    });
}

function drawCover(alertText) {
    var container = $('#container');
    var width = container.width();
    var height = container.height();

    var cover = $(document.createElement('div'));
    cover.css('position', 'absolute')
         .css('left', '0px')
         .css('top', '0px')
         .css('width', '100%')
         .css('height', $(document).height() + 'px')
         .css('z-index', '100')
         .css('background', '#fff')
         .css('opacity', 0.5)
         .css('display', 'none');

    var scrllTop = $(document).scrollTop();
    var alertBox = $(document.createElement('div'));
    alertBox.css('position', 'absolute')
            .css('z-index', '101')
            .css('width', '280px')
            .css('height', '52px')
            .css('left', (width / 2 - 140) + 'px')
            .css('top', (scrllTop + 50) + 'px')
            .css('background', 'url(images/alert_bg.png) no-repeat left top')
            .css('font-family', '"Lucida Grande"')
            .css('font-size', '12px')
            .css('text-align', 'center')

    alertBox.html('<span style="line-height:30px;">' + alertText + '<span><br/>');

    var no = $(document.createElement('a'));
    var yes = $(document.createElement('a'));
    no.css('color', '#e30b0b');
    no.css('margin-left', '20px');
    yes.css('color', '#062BA5');
    yes.css('margin-right', '20px');
    no.html('NO');
    yes.html('YES');
    no.attr('href', 'javascript:void(0);');
    yes.attr('href', 'javascript:void(0);');

    no.click(function() {
        alertBox.remove();
        cover.remove();
    });

    cover.prependTo(container);
    cover.fadeIn('fast', function() {
        yes.appendTo(alertBox);
        no.appendTo(alertBox);
        alertBox.appendTo(container);
    });

    return {'yes': yes, 'alertBox': alertBox, 'cover': cover};
}

$(document).ready(function() {
    $('input').click(function() {
        var inputName = $(this).attr('name');
        var inputId = $(this).val();
        var isChecked = $(this).is(':checked');

        if(inputName == 'group[]') {
            $('input[name="message[]"]').each(function() {
                if($(this).val().search(inputId) >= 0) {
                    if(isChecked) {
                        $(this).attr('checked', 'checked');
                    } else {
                        $(this).removeAttr('checked');
                    }
                }
            });
        }

        if(inputName == 'message[]') {
            var groupId = inputId.substr(inputId.indexOf('|') + 1);
            if(!isChecked) {
                $('input[name="group[]"][value="' + groupId + '"]').removeAttr('checked');
            }
        }

        var allUncheced = true;

        if(!isChecked) {
            $('input:checked').each(function() {
                allUncheced = false;
            });
        } else {
            allUncheced = false;
        }
		window.syncmate.allunchecked_(allUncheced);


    });
});